[//lasso
	// set error reporting to full (optional)
	lasso_errorreporting('full');
	
	// define the connection to the database
	var('connection') = array(
		-username='snppt_admin',
		-password='snipsnip',
		-database='snppt',
		-table='posts',
		-maxrecords='all'
	);

	// wrap everything in a single master inline
	inline($connection);	
		// load custom tags as needed
		tags_load('/lib/tags/', -refresh=boolean(client_param('refreshtags')));
		
		// start the asset manager
		asset_manager->options(
			-usecache=true,
			-minify=true,
			-compress=false,
			-refresh=boolean(client_param('refreshcaches')),
			-paths=map(
				'yui'=server_webroot + '/lib/tools/yuicompressor.jar',
				'scriptcache'='/lib/scripts/cache/',
				'stylecache'='/lib/styles/cache/',
				'scriptbase'='/lib/scripts/base/',
				'stylebase'='/lib/styles/base/'
			),
			-subdomains=(:
				'/lib/[^"]+?' = 'http://static.snppt.com\\1'
			)
		);

		// add some additional scripts we'll be using globally
		// (could move these into the appropriate /base/ folders)
		asset_manager->add('/lib/scripts/jquery.ui/ui/ui.core.js');
		asset_manager->add('/lib/scripts/jquery.ui/ui/ui.tabs.js');
		asset_manager->add('/lib/scripts/jquery.ui/themes/smoothness/jquery-ui-themeroller.css');
		asset_manager->add('/lib/scripts/edit.area/edit_area_full.js');
		
		// load a post or start a new one?
		var('uid') = null;
		response_filepath != '/' ? $uid = string(response_filepath)->removetrailing('/')&split('/')->last;
		var('post') = ($uid ? snppt_post( -uid=$uid) | snppt_post);
		
		// get the template
		var('template') = asset_manager->loadmodule('/lib/templates/default.html');
		
		// insert individual modules into template
		var('modules') = (: 'editor', 'viewer', 'history', 'recent');

		iterate($modules, local('i'));
			local('slot' = '#{' + #i + '}#');
			local('path' = '/lib/modules/' + #i + '/' + #i + '.inc');		
			$template->replace(#slot, asset_manager->loadmodule(#path));
		/iterate;

		// add the template to the page buffer
		content_body = $template;

		// display the page
		content_body;
	/inline;
]
